<?php
// pages/print_supplier_payment.php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';
require_once '../includes/functions.php';

// Get payment/receipt ID from GET
$receipt_id = isset($_GET['receipt_id']) ? intval($_GET['receipt_id']) : 0;
if (!$receipt_id) {
    die('Invalid receipt ID');
}

// Fetch store info
$stmt = $pdo->prepare("SELECT setting_key, setting_value FROM store_settings WHERE setting_group = 'store_info'");
$stmt->execute();
$storeSettings = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
$store = [
    'logo' => $storeSettings['store_logo'] ?? '',
    'name' => $storeSettings['store_name'] ?? 'Store',
    'address' => $storeSettings['store_address'] ?? '',
    'phone' => $storeSettings['store_phone'] ?? '',
    'email' => $storeSettings['store_email'] ?? '',
    'website' => $storeSettings['website'] ?? '',
    'vat_number' => $storeSettings['vat_number'] ?? '',
];

// Fetch receipt/payment info
$stmt = $pdo->prepare("
    SELECT sr.*, s.name as supplier_name, s.contact_person, s.phone as supplier_phone, s.email as supplier_email
    FROM supplier_receipts sr
    JOIN suppliers s ON sr.supplier_id = s.id
    WHERE sr.id = ?
");
$stmt->execute([$receipt_id]);
$payment = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$payment) {
    die('Payment/receipt not found');
}

// Parse payment details JSON
$details = json_decode($payment['payment_details'], true) ?: [];
$method = $payment['payment_method'] ?? ($details['method'] ?? '');
$reference = $details['mpesa_code'] ?? $details['cheque_number'] ?? '';
$amount_paid = $details['amount'] ?? $payment['amount_paid'] ?? $payment['paid_amount'] ?? $payment['unit_price'] * $payment['quantity'];

// Calculate remaining balance for this receipt
$remaining = ($payment['quantity'] * $payment['unit_price']) - $amount_paid;

?><!DOCTYPE html>
<html>
<head>
    <title>Supplier Payment Receipt</title>
    <style>
        body { font-family: Arial, sans-serif; }
        .header { text-align: center; }
        .logo { max-height: 80px; }
        .info-table { width: 100%; margin-bottom: 20px; }
        .info-table td { padding: 4px 8px; }
        .section-title { font-weight: bold; margin-top: 20px; }
        .footer { text-align: center; margin-top: 30px; font-size: 0.9em; color: #888; }
        @media print { .no-print { display: none; } }
    </style>
</head>
<body>
    <div class="header">
        <?php if ($store['logo']): ?>
            <img src="<?php echo htmlspecialchars($store['logo']); ?>" class="logo"><br>
        <?php endif; ?>
        <h2><?php echo htmlspecialchars($store['name']); ?></h2>
        <div><?php echo htmlspecialchars($store['address']); ?></div>
        <div>Phone: <?php echo htmlspecialchars($store['phone']); ?> | Email: <?php echo htmlspecialchars($store['email']); ?></div>
        <div>Website: <a href="<?php echo htmlspecialchars($store['website']); ?>"><?php echo htmlspecialchars($store['website']); ?></a></div>
        <div>VAT: <?php echo htmlspecialchars($store['vat_number']); ?></div>
    </div>
    <hr>
    <table class="info-table">
        <tr><td><strong>Supplier:</strong></td><td><?php echo htmlspecialchars($payment['supplier_name']); ?></td></tr>
        <tr><td><strong>Contact:</strong></td><td><?php echo htmlspecialchars($payment['contact_person']); ?></td></tr>
        <tr><td><strong>Date of Payment:</strong></td><td><?php echo date('Y-m-d H:i', strtotime($payment['updated_at'] ?? $payment['created_at'])); ?></td></tr>
        <tr><td><strong>Payment Method:</strong></td><td><?php echo htmlspecialchars(ucfirst($method)); ?></td></tr>
        <tr><td><strong>Reference:</strong></td><td><?php echo htmlspecialchars($reference); ?></td></tr>
        <tr><td><strong>Amount Paid:</strong></td><td><?php echo number_format($amount_paid, 2); ?></td></tr>
        <tr><td><strong>Amount Remaining:</strong></td><td><?php echo number_format($remaining, 2); ?></td></tr>
        <tr><td><strong>Receipt #:</strong></td><td><?php echo htmlspecialchars($payment['id']); ?></td></tr>
    </table>
    <div class="footer">
        Printed on <?php echo date('Y-m-d H:i'); ?> | <span class="no-print"><button onclick="window.print()">Print</button></span>
    </div>
</body>
</html> 